    <?php 
        $queryComponentiDaMostrare = "SELECT c.id, c.idSezione, c.idElemento, c.classeSezione, c.aTuttaLarghezza, c.margineSezione, c.paddingSezione, c.testo, c.coloreSfondo, c.immagineSfondo, c.videoSfondo, cm.nome, cm.tipo, cm.icona, cm.paginaGestione, cm.tabellaRiferimento, c.posizione FROM geecD_composizionePagine AS c JOIN geecD_componenti AS cm ON c.idComponente=cm.id WHERE c.idPagina = {$contenuto->getId()} ORDER BY c.posizione ASC";
        $risComponenti = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);
        
        // se nella pagina ci sono più di 7 componenti viene inserito anche un pulsante in 
        // alto per non costringere l'utente ad arrivare in fondo alla pagina
        if($risComponenti->num_rows>7) {
    ?>
            <button type="button" class="btn btn-success btn-block mb-3" data-toggle="modal" data-target="#aggiungi-componente"><i class="fas fa-plus"></i> Aggiungi un componente</button>
    <?php
        }
        if($risComponenti->num_rows==0) {
    ?>
            <div class="card bg-light text-center mb-3">
                <div class="card-body">
                    Non ci sono componenti
                </div>
            </div>
    <?php
        }
        else {
            
            while($componente = $risComponenti->fetch_assoc()) {
                if($componente["tipo"]=="componenteDinamico" || $componente["tipo"]=="pagine") {
                    $nomeElemento = "";
                }
                else {
                    $elemento = $geecomDb->leggiSingolaRiga($componente["tabellaRiferimento"],$componente["idElemento"]);
                    $nomeElemento = filter_var($elemento["nome"],FILTER_SANITIZE_STRING);
                }
                
                if($componente["tipo"]!="componenteDinamico") {
                    $linkModificaComponente = creaLinkModifica($componente);
                    $stringaPulsanteModifica = "onclick=\"{location.href='$linkModificaComponente';}\"";
                }
                else {
                    $stringaPulsanteModifica = "data-toggle=\"modal\" data-target=\"#configuraComponente{$componente["id"]}";
                }
                
                $posizionePrecedente = $componente["posizione"]-1;
                $posizioneSuccessiva = $componente["posizione"]+1;
                echo"<div id=\"componentePagina{$componente["id"]}\" class=\"card mb-3\">
                    <div class=\"card-header py-1 pr-sm-1 d-sm-flex justify-content-between align-items-center text-center\">
                        <div class=\"mb-1 mb-sm-0 d-flex align-items-center justify-content-start\">
                            <small class=\"text-muted mr-3\"><em><strong>ID:</strong></em> {$componente["idSezione"]} </small>
                            <small class=\"text-muted\"><em><strong>Classi:</strong></em> {$componente["classeSezione"]} </small>
                        </div>
                        <div class=\"azioni d-flex align-items-center justify-content-end\">
                            <form class=\"d-inline-flex mr-sm-1\">
                                <div class=\"input-group input-group-sm d-flex align-items-center\">
                                    <small class=\"text-muted mr-2\">Pos.</small>
                                    <input type=\"number\" class=\"form-control\" aria-label=\"posizione\" min=\"1\" value=\"{$componente["posizione"]}\" id=\"posizioneComponente{$componente["id"]}\">
                                    <div class=\"input-group-append\">
                                        <button class=\"btn btn-primary\" type=\"button\" onclick=\"modificaPosizioneComponenteDaInput({$componente["id"]})\">Salva</button>
                                    </div>
                                </div>
                            </form>
                            <div class=\"btn-group\" role=\"group\" aria-label=\"Basic example\">
                                <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Sposta su\" onclick={modificaPosizioneComponente({$componente["id"]},$posizionePrecedente);}><i class=\"fas fa-arrow-up\" ></i></button>
                                <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Sposta giu\" onclick={modificaPosizioneComponente({$componente["id"]},$posizioneSuccessiva);}><i class=\"fas fa-arrow-down\"></i></button>
                                <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Impostazioni sezione\" onclick=\"modificaImpostazioniSezione({$componente["id"]},'{$componente["idSezione"]}','{$componente["classeSezione"]}','{$componente["aTuttaLarghezza"]}','{$componente["margineSezione"]}','{$componente["paddingSezione"]}','{$componente["coloreSfondo"]}','{$componente["immagineSfondo"]}','{$componente["videoSfondo"]}')\"><i class=\"fas fa-cog\"></i></button>
                                <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Duplica\" onclick=\"duplicaComponente({$componente["id"]})\"><i class=\"far fa-clone\"></i></button>
                                <button type=\"button\" class=\"btn btn-light elimina\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Elimina\" onclick=\"eliminaComponentePagina({$componente["id"]},'{$componente["icona"]}','{$componente["nome"]}','$nomeElemento')\" ><i class=\"far fa-trash-alt\"></i></button>
                            </div>
                       </div>
                    </div>
                    <div class= \"card-body py-lg-0 d-flex align-items-center\">
                        <img class=\"thumb d-none d-lg-block\" src=\"{$componente["icona"]}\">
                        <div class=\"input-group mr-3\">
                            <span class=\"mr-3 align-self-center text-primary\"><em>{$componente["nome"]}</em></span>";
                            if($componente["tipo"]=="componenteDinamicoPagine") {
                                $queryElementiComponente = "SELECT * FROM {$componente["tabellaRiferimento"]}";
                                $risElementoComponente   = $geecomDb->eseguiQueryLettura($queryElementiComponente);
                                echo"<select class=\"form-control form-control-sm\" id=\"idElementoComponente{$componente["id"]}\">";
                                        while($elemento = $risElementoComponente->fetch_assoc()) {
                                            if($componente["idElemento"]==$elemento["id"]) {
                                                echo"<option value=\"{$elemento["id"]}\" selected >{$elemento["nome"]}</option>";
                                            }
                                            else {
                                                echo"<option value=\"{$elemento["id"]}\">{$elemento["nome"]}</option>";
                                            }
                                        }
                                echo"</select>
                                <div class=\"input-group-append\">
                                    <button type=\"button\" class=\"btn btn-primary btn-sm\" onclick=\"cambiaIdElemento({$componente["id"]})\">Salva</button>
                                </div>";
                            }
                            else {
                                echo"<span class=\"text-truncate text-muted d-block w-75\">". substr(strip_tags($componente["testo"]),0,90)."</span>";
                            }
                            echo"
                        </div>";
                        
                        if($componente["nome"]!="Modulo login" && $componente["nome"]!="Modulo registrati" && $componente["nome"]!="Modulo login/registrati"  && $componente["nome"]!="Modulo recupera password"  && $componente["nome"]!="Visualizzatore notifiche" && $componente["nome"]!="Visualizzatore pagina profilo") {
                            echo"<div class=\"btn-group\">
                                <button type=\"button\" class=\"btn btn-primary btn-sm text-nowrap\" $stringaPulsanteModifica \"><span class=\"d-none d-lg-inline-block\">Configura</span><i class=\"far fa-edit fa-fw ml-1\"></i></button>
                            </div>";
                        }
                        echo"
                    </div>
                </div>";
            }
        }
